// WaitQueue.cpp starts

#include "WaitQueue.h"
#include "Debug.h"

WaitQueue::WaitQueue()
{
	numItems = create_sem(0, "numItems"); // 0 items in queue initially
	
	if (numItems < B_OK) {
		Debug('e', "WaitQueue::WaitQueue: Could not create semaphore");
	}
}

WaitQueue::~WaitQueue()
{
	delete_sem(numItems);
}

void WaitQueue::Add(BMessage *msg)
{
	Lock();
	// BeOS documentation note: Caller gives up ownership of passed
	// message. This is not documented in BMessageQueue, but the code
	// fails miserably if you delete the messsage after passing it!
	AddMessage(msg);
	Unlock();
	
	release_sem(numItems); // increment number of items; unblock any process waiting for an item
}

BMessage *WaitQueue::Remove()
{
	BMessage *msg;

	acquire_sem(numItems); // will block if numItems == 0
	
	Lock();
	msg = NextMessage();
	Unlock();

	return msg;
}

// WaitQueue.cpp ends
